﻿namespace Code6587EN.Ch05.GetPagesCheckedOut
{
    using Microsoft.SharePoint;
    using Microsoft.SharePoint.Administration;
    using Microsoft.SharePoint.Publishing;
    using Microsoft.SharePoint.WebPartPages;
    using System;
    using System.Linq;

    /// <summary>
    /// Console Application to get the Publishing Pages currently Checked Out
    /// </summary>
    class Program
    {
        static void Main(string[] args)
        {
            // Open the Site Collection containing the Site
            using (var site = new SPSite("http://sharepoint/publishing"))
            {
                // Open the Site
                using (var web = site.OpenWeb())
                {
                    // Get the Publishing Site from the SharePoint Site
                    var pubWeb = PublishingWeb.GetPublishingWeb(web);

                    // Get the Publishing Pages from the Site
	                var pages = pubWeb.GetPublishingPages();

	                // Iterate through the collection of Pages
	                foreach (var page in pages)
	                {
		                // If the Page is checked out, output the details
		                if (page.ListItem.File.Level == SPFileLevel.Checkout)
		                {
			                Console.WriteLine(page.Url);
			                Console.WriteLine("By: " + page.ListItem.File.CheckedOutByUser.LoginName);
			                Console.WriteLine("Since: " + page.ListItem.File.CheckedOutDate.ToString());
                            Console.WriteLine("");
		                }
	                }
                }
            }

            // Wait for a key to be pressed before closing the application
            Console.WriteLine("Press Any Key to Continue...");
            Console.Read();
        }
    }
}
